package org.kodein.emoji.symbols.zodiac

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Capricorn: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♑",
        description = "Capricorn",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("capricorn", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Symbols: zodiac: Capricorn.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Capricorn: Emoji get() = _Capricorn
