package org.kodein.emoji.travel_places.place_religious

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPlaceReligious() {
    add(intArrayOf(0x26e9, 0xfe0f), _ShintoShrine)
    add(intArrayOf(0x26e9), _ShintoShrine)
    add(intArrayOf(0x1f54d), _Synagogue)
    add(intArrayOf(0x1f54c), _Mosque)
    add(intArrayOf(0x1f54b), _Kaaba)
    add(intArrayOf(0x1f6d5), _HinduTemple)
    add(intArrayOf(0x26ea), _Church)
}

internal fun MutableList<Emoji>.addAllPlaceReligious() {
    add(_ShintoShrine)
    add(_Synagogue)
    add(_Mosque)
    add(_Kaaba)
    add(_HinduTemple)
    add(_Church)
}

/**
 * All Emoji of the Travel & Places: place-religious subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allPlaceReligious(): List<Emoji> =
    ArrayList<Emoji>(6).apply { addAllPlaceReligious() }
