package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBhutan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇹",
        description = "flag: Bhutan",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-bhutan", "bhutan-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Bhutan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBhutan: Emoji get() = _FlagBhutan

/**
 * Alias to emoji [FlagBhutan] (Flags: country-flag: flag: Bhutan).
*/
public val Emoji.Companion.BhutanFlag: Emoji get() = _FlagBhutan
