package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagEstonia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇪🇪",
        description = "flag: Estonia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-estonia", "estonia-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Estonia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagEstonia: Emoji get() = _FlagEstonia

/**
 * Alias to emoji [FlagEstonia] (Flags: country-flag: flag: Estonia).
*/
public val Emoji.Companion.EstoniaFlag: Emoji get() = _FlagEstonia
