package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGabon: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇦",
        description = "flag: Gabon",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-gabon", "gabon-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Gabon.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGabon: Emoji get() = _FlagGabon

/**
 * Alias to emoji [FlagGabon] (Flags: country-flag: flag: Gabon).
*/
public val Emoji.Companion.GabonFlag: Emoji get() = _FlagGabon
