package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGermany: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇩🇪",
        description = "flag: Germany",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flag-germany", "germany-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Germany.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGermany: Emoji get() = _FlagGermany

/**
 * Alias to emoji [FlagGermany] (Flags: country-flag: flag: Germany).
*/
public val Emoji.Companion.GermanyFlag: Emoji get() = _FlagGermany
