package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMartinique: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇶",
        description = "flag: Martinique",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-martinique", "martinique-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Martinique.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMartinique: Emoji get() = _FlagMartinique

/**
 * Alias to emoji [FlagMartinique] (Flags: country-flag: flag: Martinique).
*/
public val Emoji.Companion.MartiniqueFlag: Emoji get() = _FlagMartinique
