package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMonaco: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇨",
        description = "flag: Monaco",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-monaco", "monaco-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Monaco.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMonaco: Emoji get() = _FlagMonaco

/**
 * Alias to emoji [FlagMonaco] (Flags: country-flag: flag: Monaco).
*/
public val Emoji.Companion.MonacoFlag: Emoji get() = _FlagMonaco
