package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMozambique: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇿",
        description = "flag: Mozambique",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-mozambique", "mozambique-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Mozambique.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMozambique: Emoji get() = _FlagMozambique

/**
 * Alias to emoji [FlagMozambique] (Flags: country-flag: flag: Mozambique).
*/
public val Emoji.Companion.MozambiqueFlag: Emoji get() = _FlagMozambique
