package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMyanmarBurma: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇲",
        description = "flag: Myanmar (Burma)",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-myanmar-burma-", "myanmar-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Myanmar (Burma).
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMyanmarBurma: Emoji get() = _FlagMyanmarBurma

/**
 * Alias to emoji [FlagMyanmarBurma] (Flags: country-flag: flag: Myanmar (Burma)).
*/
public val Emoji.Companion.MyanmarFlag: Emoji get() = _FlagMyanmarBurma
