package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSouthKorea: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇰🇷",
        description = "flag: South Korea",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flag-south-korea", "south-korea-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: South Korea.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSouthKorea: Emoji get() = _FlagSouthKorea

/**
 * Alias to emoji [FlagSouthKorea] (Flags: country-flag: flag: South Korea).
*/
public val Emoji.Companion.SouthKoreaFlag: Emoji get() = _FlagSouthKorea
