package org.kodein.emoji.objects

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.objects.medical.*
import org.kodein.emoji.objects.mail.*
import org.kodein.emoji.objects.sound.*
import org.kodein.emoji.objects.office.*
import org.kodein.emoji.objects.book_paper.*
import org.kodein.emoji.objects.tool.*
import org.kodein.emoji.objects.light_video.*
import org.kodein.emoji.objects.computer.*
import org.kodein.emoji.objects.music.*
import org.kodein.emoji.objects.money.*
import org.kodein.emoji.objects.phone.*
import org.kodein.emoji.objects.writing.*
import org.kodein.emoji.objects.science.*
import org.kodein.emoji.objects.household.*
import org.kodein.emoji.objects.lock.*
import org.kodein.emoji.objects.other_object.*
import org.kodein.emoji.objects.clothing.*
import org.kodein.emoji.objects.musical_instrument.*


internal fun EmojiFinder.addAllObjects() {
    addAllMedical()
    addAllMail()
    addAllSound()
    addAllOffice()
    addAllBookPaper()
    addAllTool()
    addAllLightVideo()
    addAllComputer()
    addAllMusic()
    addAllMoney()
    addAllPhone()
    addAllWriting()
    addAllScience()
    addAllHousehold()
    addAllLock()
    addAllOtherObject()
    addAllClothing()
    addAllMusicalInstrument()
}

internal fun MutableList<Emoji>.addAllObjects() {
    addAllMedical()
    addAllMail()
    addAllSound()
    addAllOffice()
    addAllBookPaper()
    addAllTool()
    addAllLightVideo()
    addAllComputer()
    addAllMusic()
    addAllMoney()
    addAllPhone()
    addAllWriting()
    addAllScience()
    addAllHousehold()
    addAllLock()
    addAllOtherObject()
    addAllClothing()
    addAllMusicalInstrument()
}

/**
 * All Emoji of the Objects group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allObjects(): List<Emoji> =
    ArrayList<Emoji>(262).apply { addAllObjects() }

internal fun allObjectsSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "medical" to { Emoji.allMedical() },
        "mail" to { Emoji.allMail() },
        "sound" to { Emoji.allSound() },
        "office" to { Emoji.allOffice() },
        "book_paper" to { Emoji.allBookPaper() },
        "tool" to { Emoji.allTool() },
        "light_video" to { Emoji.allLightVideo() },
        "computer" to { Emoji.allComputer() },
        "music" to { Emoji.allMusic() },
        "money" to { Emoji.allMoney() },
        "phone" to { Emoji.allPhone() },
        "writing" to { Emoji.allWriting() },
        "science" to { Emoji.allScience() },
        "household" to { Emoji.allHousehold() },
        "lock" to { Emoji.allLock() },
        "other_object" to { Emoji.allOtherObject() },
        "clothing" to { Emoji.allClothing() },
        "musical_instrument" to { Emoji.allMusicalInstrument() },
    )
