package org.kodein.emoji.objects.household

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FireExtinguisher: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧯",
        description = "fire extinguisher",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("fire-extinguisher", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: household: fire extinguisher.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FireExtinguisher: Emoji get() = _FireExtinguisher
