package org.kodein.emoji.people_body.body_parts

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _FlexedBiceps: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "💪",
        description = "flexed biceps",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flexed-biceps", "muscle", "flex", "bicep", "strong"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: body-parts: flexed biceps.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlexedBiceps: SkinTone1Emoji get() = _FlexedBiceps

/**
 * Alias to emoji [FlexedBiceps] (People & Body: body-parts: flexed biceps).
*/
public val Emoji.Companion.Muscle: SkinTone1Emoji get() = _FlexedBiceps

/**
 * Alias to emoji [FlexedBiceps] (People & Body: body-parts: flexed biceps).
*/
public val Emoji.Companion.Flex: SkinTone1Emoji get() = _FlexedBiceps

/**
 * Alias to emoji [FlexedBiceps] (People & Body: body-parts: flexed biceps).
*/
public val Emoji.Companion.Bicep: SkinTone1Emoji get() = _FlexedBiceps

/**
 * Alias to emoji [FlexedBiceps] (People & Body: body-parts: flexed biceps).
*/
public val Emoji.Companion.Strong: SkinTone1Emoji get() = _FlexedBiceps
