package org.kodein.emoji.people_body.hand_fingers_open

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.UnqualifiedSkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HandWithFingersSplayed: SkinTone1Emoji = UnqualifiedSkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🖐️",
        description = "hand with fingers splayed",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("hand-with-fingers-splayed", "palm"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    uqString = "🖐",
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-fingers-open: hand with fingers splayed.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HandWithFingersSplayed: SkinTone1Emoji get() = _HandWithFingersSplayed

/**
 * Alias to emoji [HandWithFingersSplayed] (People & Body: hand-fingers-open: hand with fingers splayed).
*/
public val Emoji.Companion.Palm: SkinTone1Emoji get() = _HandWithFingersSplayed
