package org.kodein.emoji.people_body.person_gesture

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonTippingHand: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "💁",
        description = "person tipping hand",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-tipping-hand", "tipping-hand"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-gesture: person tipping hand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonTippingHand: SkinTone1Emoji get() = _PersonTippingHand

/**
 * Alias to emoji [PersonTippingHand] (People & Body: person-gesture: person tipping hand).
*/
public val Emoji.Companion.TippingHand: SkinTone1Emoji get() = _PersonTippingHand
