package org.kodein.emoji.smileys_emotion.face_negative

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmilingFaceWithHorns: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😈",
        description = "smiling face with horns",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("smiling-face-with-horns", "imp-smile"),
        emoticons = listOf("3:)"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-negative: smiling face with horns.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmilingFaceWithHorns: Emoji get() = _SmilingFaceWithHorns

/**
 * Alias to emoji [SmilingFaceWithHorns] (Smileys & Emotion: face-negative: smiling face with horns).
*/
public val Emoji.Companion.ImpSmile: Emoji get() = _SmilingFaceWithHorns
