package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseDiscountButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🈹",
        description = "Japanese “discount” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-discount-button", "discount"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “discount” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseDiscountButton: Emoji get() = _JapaneseDiscountButton

/**
 * Alias to emoji [JapaneseDiscountButton] (Symbols: alphanum: Japanese “discount” button).
*/
public val Emoji.Companion.Discount: Emoji get() = _JapaneseDiscountButton
