package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseFreeOfChargeButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🈚",
        description = "Japanese “free of charge” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-free-of-charge-button", "free-of-charge"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “free of charge” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseFreeOfChargeButton: Emoji get() = _JapaneseFreeOfChargeButton

/**
 * Alias to emoji [JapaneseFreeOfChargeButton] (Symbols: alphanum: Japanese “free of charge” button).
*/
public val Emoji.Companion.FreeOfCharge: Emoji get() = _JapaneseFreeOfChargeButton
