package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WhiteLargeSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⬜",
        description = "white large square",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("white-large-square", "white-square"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: white large square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WhiteLargeSquare: Emoji get() = _WhiteLargeSquare

/**
 * Alias to emoji [WhiteLargeSquare] (Symbols: geometric: white large square).
*/
public val Emoji.Companion.WhiteSquare: Emoji get() = _WhiteLargeSquare
