package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NameBadge: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📛",
        description = "name badge",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("name-badge", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: other-symbol: name badge.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NameBadge: Emoji get() = _NameBadge
