package org.kodein.emoji.travel_places.place_other

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PlaygroundSlide: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🛝",
        description = "playground slide",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("playground-slide", "slide", "playground"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: place-other: playground slide.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PlaygroundSlide: Emoji get() = _PlaygroundSlide

/**
 * Alias to emoji [PlaygroundSlide] (Travel & Places: place-other: playground slide).
*/
public val Emoji.Companion.Slide: Emoji get() = _PlaygroundSlide

/**
 * Alias to emoji [PlaygroundSlide] (Travel & Places: place-other: playground slide).
*/
public val Emoji.Companion.Playground: Emoji get() = _PlaygroundSlide
