package org.kodein.emoji.animals_nature.animal_reptile

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAnimalReptile() {
    add(intArrayOf(0x1f432), _DragonFace)
    add(intArrayOf(0x1f98e), _Lizard)
    add(intArrayOf(0x1f409), _Dragon)
    add(intArrayOf(0x1f996), _TRex)
    add(intArrayOf(0x1f995), _Sauropod)
    add(intArrayOf(0x1f422), _Turtle)
    add(intArrayOf(0x1f40a), _Crocodile)
    add(intArrayOf(0x1f40d), _Snake)
}

internal fun MutableList<Emoji>.addAllAnimalReptile() {
    add(_DragonFace)
    add(_Lizard)
    add(_Dragon)
    add(_TRex)
    add(_Sauropod)
    add(_Turtle)
    add(_Crocodile)
    add(_Snake)
}

/**
 * All Emoji of the Animals & Nature: animal-reptile subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allAnimalReptile(): List<Emoji> =
    ArrayList<Emoji>(8).apply { addAllAnimalReptile() }
