package org.kodein.emoji.animals_nature.plant_other

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Seedling: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌱",
        description = "seedling",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("seedling", "plant", "seed"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Animals & Nature: plant-other: seedling.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Seedling: Emoji get() = _Seedling

/**
 * Alias to emoji [Seedling] (Animals & Nature: plant-other: seedling).
*/
public val Emoji.Companion.Plant: Emoji get() = _Seedling

/**
 * Alias to emoji [Seedling] (Animals & Nature: plant-other: seedling).
*/
public val Emoji.Companion.Seed: Emoji get() = _Seedling
