package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAnguilla: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇮",
        description = "flag: Anguilla",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-anguilla", "anguilla-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Anguilla.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAnguilla: Emoji get() = _FlagAnguilla

/**
 * Alias to emoji [FlagAnguilla] (Flags: country-flag: flag: Anguilla).
*/
public val Emoji.Companion.AnguillaFlag: Emoji get() = _FlagAnguilla
