package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCuba: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇺",
        description = "flag: Cuba",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-cuba", "cuba-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Cuba.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCuba: Emoji get() = _FlagCuba

/**
 * Alias to emoji [FlagCuba] (Flags: country-flag: flag: Cuba).
*/
public val Emoji.Companion.CubaFlag: Emoji get() = _FlagCuba
