package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGibraltar: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇮",
        description = "flag: Gibraltar",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-gibraltar", "gibraltar-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Gibraltar.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGibraltar: Emoji get() = _FlagGibraltar

/**
 * Alias to emoji [FlagGibraltar] (Flags: country-flag: flag: Gibraltar).
*/
public val Emoji.Companion.GibraltarFlag: Emoji get() = _FlagGibraltar
