package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMali: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇱",
        description = "flag: Mali",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-mali", "mali-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Mali.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMali: Emoji get() = _FlagMali

/**
 * Alias to emoji [FlagMali] (Flags: country-flag: flag: Mali).
*/
public val Emoji.Companion.MaliFlag: Emoji get() = _FlagMali
