package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagQatar: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇶🇦",
        description = "flag: Qatar",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-qatar", "qatar-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Qatar.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagQatar: Emoji get() = _FlagQatar

/**
 * Alias to emoji [FlagQatar] (Flags: country-flag: flag: Qatar).
*/
public val Emoji.Companion.QatarFlag: Emoji get() = _FlagQatar
