package org.kodein.emoji.objects.music

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MusicalScore: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎼",
        description = "musical score",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("musical-score", "treble-clef"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: music: musical score.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MusicalScore: Emoji get() = _MusicalScore

/**
 * Alias to emoji [MusicalScore] (Objects: music: musical score).
*/
public val Emoji.Companion.TrebleClef: Emoji get() = _MusicalScore
