package org.kodein.emoji.people_body.hand_fingers_partial

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.UnqualifiedSkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _VictoryHand: SkinTone1Emoji = UnqualifiedSkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "✌️",
        description = "victory hand",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("victory-hand", "v", "peace-hand", "victory"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
    uqString = "✌",
    sk1c = 1,
)

/**
 * Emoji People & Body: hand-fingers-partial: victory hand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.VictoryHand: SkinTone1Emoji get() = _VictoryHand

/**
 * Alias to emoji [VictoryHand] (People & Body: hand-fingers-partial: victory hand).
*/
public val Emoji.Companion.V: SkinTone1Emoji get() = _VictoryHand

/**
 * Alias to emoji [VictoryHand] (People & Body: hand-fingers-partial: victory hand).
*/
public val Emoji.Companion.PeaceHand: SkinTone1Emoji get() = _VictoryHand

/**
 * Alias to emoji [VictoryHand] (People & Body: hand-fingers-partial: victory hand).
*/
public val Emoji.Companion.Victory: SkinTone1Emoji get() = _VictoryHand
