package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonWalking: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🚶",
        description = "person walking",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-walking", "walking"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-activity: person walking.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonWalking: SkinTone1Emoji get() = _PersonWalking

/**
 * Alias to emoji [PersonWalking] (People & Body: person-activity: person walking).
*/
public val Emoji.Companion.Walking: SkinTone1Emoji get() = _PersonWalking
