package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GrimacingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😬",
        description = "grimacing face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("grimacing-face", "grimacing"),
        emoticons = listOf(":-|"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: grimacing face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GrimacingFace: Emoji get() = _GrimacingFace

/**
 * Alias to emoji [GrimacingFace] (Smileys & Emotion: face-neutral-skeptical: grimacing face).
*/
public val Emoji.Companion.Grimacing: Emoji get() = _GrimacingFace
