package org.kodein.emoji.smileys_emotion.face_unwell

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ExplodingHead: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤯",
        description = "exploding head",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("exploding-head", "mind-blown"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-unwell: exploding head.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ExplodingHead: Emoji get() = _ExplodingHead

/**
 * Alias to emoji [ExplodingHead] (Smileys & Emotion: face-unwell: exploding head).
*/
public val Emoji.Companion.MindBlown: Emoji get() = _ExplodingHead
