package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PlayButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "▶️",
        description = "play button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("play-button", "arrow-forward"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: av-symbol: play button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PlayButton: Emoji get() = _PlayButton

/**
 * Alias to emoji [PlayButton] (Symbols: av-symbol: play button).
*/
public val Emoji.Companion.ArrowForward: Emoji get() = _PlayButton
