package org.kodein.emoji.symbols.warning

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NoMobilePhones: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📵",
        description = "no mobile phones",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("no-mobile-phones", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: warning: no mobile phones.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NoMobilePhones: Emoji get() = _NoMobilePhones
