package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SunWithFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌞",
        description = "sun with face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("sun-with-face", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: sun with face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SunWithFace: Emoji get() = _SunWithFace
