package org.kodein.emoji.animals_nature.animal_bird

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FrontFacingBabyChick: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🐥",
        description = "front-facing baby chick",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("front-facing-baby-chick", "hatched-chick"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Animals & Nature: animal-bird: front-facing baby chick.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FrontFacingBabyChick: Emoji get() = _FrontFacingBabyChick

/**
 * Alias to emoji [FrontFacingBabyChick] (Animals & Nature: animal-bird: front-facing baby chick).
*/
public val Emoji.Companion.HatchedChick: Emoji get() = _FrontFacingBabyChick
