package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagComoros: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇰🇲",
        description = "flag: Comoros",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-comoros", "comoros-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.6666666f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Comoros.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagComoros: Emoji get() = _FlagComoros

/**
 * Alias to emoji [FlagComoros] (Flags: country-flag: flag: Comoros).
*/
public val Emoji.Companion.ComorosFlag: Emoji get() = _FlagComoros
