package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMaldives: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇻",
        description = "flag: Maldives",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-maldives", "maldives-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Maldives.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMaldives: Emoji get() = _FlagMaldives

/**
 * Alias to emoji [FlagMaldives] (Flags: country-flag: flag: Maldives).
*/
public val Emoji.Companion.MaldivesFlag: Emoji get() = _FlagMaldives
