package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagVietnam: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇻🇳",
        description = "flag: Vietnam",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-vietnam", "vietnam-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Vietnam.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagVietnam: Emoji get() = _FlagVietnam

/**
 * Alias to emoji [FlagVietnam] (Flags: country-flag: flag: Vietnam).
*/
public val Emoji.Companion.VietnamFlag: Emoji get() = _FlagVietnam
