package org.kodein.emoji.objects.household

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RollOfPaper: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧻",
        description = "roll of paper",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("roll-of-paper", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: household: roll of paper.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RollOfPaper: Emoji get() = _RollOfPaper
