package org.kodein.emoji.objects.household

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SafetyPin: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧷",
        description = "safety pin",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("safety-pin", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: household: safety pin.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SafetyPin: Emoji get() = _SafetyPin
