package org.kodein.emoji.objects.musical_instrument

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllMusicalInstrument() {
    add(intArrayOf(0x1f3b7), _Saxophone)
    add(intArrayOf(0x1fa97), _Accordion)
    add(intArrayOf(0x1f3b8), _Guitar)
    add(intArrayOf(0x1f3b9), _MusicalKeyboard)
    add(intArrayOf(0x1f3ba), _Trumpet)
    add(intArrayOf(0x1f3bb), _Violin)
    add(intArrayOf(0x1fa95), _Banjo)
    add(intArrayOf(0x1f941), _Drum)
    add(intArrayOf(0x1fa98), _LongDrum)
    add(intArrayOf(0x1fa87), _Maracas)
    add(intArrayOf(0x1fa88), _Flute)
}

internal suspend fun SequenceScope<Emoji>.yieldAllMusicalInstrument() {
    yield(_Saxophone)
    yield(_Accordion)
    yield(_Guitar)
    yield(_MusicalKeyboard)
    yield(_Trumpet)
    yield(_Violin)
    yield(_Banjo)
    yield(_Drum)
    yield(_LongDrum)
    yield(_Maracas)
    yield(_Flute)
}

internal val countMusicalInstrument = 11

/**
 * All Emoji of the Objects: musical-instrument subgroup.
*/
public fun Emoji.Companion.sequenceMusicalInstrument(): Sequence<Emoji> =
    sequence { yieldAllMusicalInstrument() }

/**
 * All Emoji of the Objects: musical-instrument subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listMusicalInstrument(): List<Emoji> =
    ArrayList<Emoji>(countMusicalInstrument).also { list -> sequenceMusicalInstrument().forEach { list.add(it) } }

@Deprecated("Renamed listMusicalInstrument.", replaceWith = ReplaceWith("listMusicalInstrument()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allMusicalInstrument(): List<Emoji> =
    listMusicalInstrument()
