package org.kodein.emoji.objects.phone

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MobilePhoneWithArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📲",
        description = "mobile phone with arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("mobile-phone-with-arrow", "phone-with-arrow"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: phone: mobile phone with arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MobilePhoneWithArrow: Emoji get() = _MobilePhoneWithArrow

/**
 * Alias to emoji [MobilePhoneWithArrow] (Objects: phone: mobile phone with arrow).
*/
public val Emoji.Companion.PhoneWithArrow: Emoji get() = _MobilePhoneWithArrow
