package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _KissManMan: SkinTone2Emoji = SkinTone2EmojiImpl(
    details = Emoji.Details(
        string = "👨‍❤️‍💋‍👨",
        description = "kiss: man, man",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("kiss-man-man", "kiss-man-and-man"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk21c = 2,
    sk22c = 11,
)

/**
 * Emoji People & Body: family: kiss: man, man.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.KissManMan: SkinTone2Emoji get() = _KissManMan

/**
 * Alias to emoji [KissManMan] (People & Body: family: kiss: man, man).
*/
public val Emoji.Companion.KissManAndMan: SkinTone2Emoji get() = _KissManMan
