package org.kodein.emoji.people_body.hand_fingers_open

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PalmUpHand: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🫴",
        description = "palm up hand",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("palm-up-hand", "palm-up", "throw"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-fingers-open: palm up hand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PalmUpHand: SkinTone1Emoji get() = _PalmUpHand

/**
 * Alias to emoji [PalmUpHand] (People & Body: hand-fingers-open: palm up hand).
*/
public val Emoji.Companion.PalmUp: SkinTone1Emoji get() = _PalmUpHand

/**
 * Alias to emoji [PalmUpHand] (People & Body: hand-fingers-open: palm up hand).
*/
public val Emoji.Companion.Throw: SkinTone1Emoji get() = _PalmUpHand
