package org.kodein.emoji.people_body.hand_fingers_partial

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHandFingersPartial() {
    add(intArrayOf(0x1f44c), _OkHand)
    addVariations(intArrayOf(0x1f44c, 0x0), _OkHand, 1)
    add(intArrayOf(0x1f90c), _PinchedFingers)
    addVariations(intArrayOf(0x1f90c, 0x0), _PinchedFingers, 1)
    add(intArrayOf(0x1f90f), _PinchingHand)
    addVariations(intArrayOf(0x1f90f, 0x0), _PinchingHand, 1)
    add(intArrayOf(0x270c, 0xfe0f), _VictoryHand)
    add(intArrayOf(0x270c), _VictoryHand)
    addVariations(intArrayOf(0x270c, 0x0), _VictoryHand, 1)
    add(intArrayOf(0x1f91e), _CrossedFingers)
    addVariations(intArrayOf(0x1f91e, 0x0), _CrossedFingers, 1)
    add(intArrayOf(0x1faf0), _HandWithIndexFingerAndThumbCrossed)
    addVariations(intArrayOf(0x1faf0, 0x0), _HandWithIndexFingerAndThumbCrossed, 1)
    add(intArrayOf(0x1f91f), _LoveYouGesture)
    addVariations(intArrayOf(0x1f91f, 0x0), _LoveYouGesture, 1)
    add(intArrayOf(0x1f918), _SignOfTheHorns)
    addVariations(intArrayOf(0x1f918, 0x0), _SignOfTheHorns, 1)
    add(intArrayOf(0x1f919), _CallMeHand)
    addVariations(intArrayOf(0x1f919, 0x0), _CallMeHand, 1)
}

internal suspend fun SequenceScope<Emoji>.yieldAllHandFingersPartial() {
    yield(_OkHand)
    yield(_PinchedFingers)
    yield(_PinchingHand)
    yield(_VictoryHand)
    yield(_CrossedFingers)
    yield(_HandWithIndexFingerAndThumbCrossed)
    yield(_LoveYouGesture)
    yield(_SignOfTheHorns)
    yield(_CallMeHand)
}

internal val countHandFingersPartial = 9

/**
 * All Emoji of the People & Body: hand-fingers-partial subgroup.
*/
public fun Emoji.Companion.sequenceHandFingersPartial(): Sequence<Emoji> =
    sequence { yieldAllHandFingersPartial() }

/**
 * All Emoji of the People & Body: hand-fingers-partial subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listHandFingersPartial(): List<Emoji> =
    ArrayList<Emoji>(countHandFingersPartial).also { list -> sequenceHandFingersPartial().forEach { list.add(it) } }

@Deprecated("Renamed listHandFingersPartial.", replaceWith = ReplaceWith("listHandFingersPartial()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allHandFingersPartial(): List<Emoji> =
    listHandFingersPartial()
