package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.UnqualifiedSkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PersonGolfing: SkinTone1Emoji = UnqualifiedSkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🏌️",
        description = "person golfing",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("person-golfing", "golfing"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    uqString = "🏌",
    sk1c = 2,
)

/**
 * Emoji People & Body: person-sport: person golfing.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonGolfing: SkinTone1Emoji get() = _PersonGolfing

/**
 * Alias to emoji [PersonGolfing] (People & Body: person-sport: person golfing).
*/
public val Emoji.Companion.Golfing: SkinTone1Emoji get() = _PersonGolfing
