package org.kodein.emoji.smileys_emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.smileys_emotion.face_smiling.*
import org.kodein.emoji.smileys_emotion.face_affection.*
import org.kodein.emoji.smileys_emotion.face_tongue.*
import org.kodein.emoji.smileys_emotion.face_hand.*
import org.kodein.emoji.smileys_emotion.face_neutral_skeptical.*
import org.kodein.emoji.smileys_emotion.face_sleepy.*
import org.kodein.emoji.smileys_emotion.face_unwell.*
import org.kodein.emoji.smileys_emotion.face_hat.*
import org.kodein.emoji.smileys_emotion.face_glasses.*
import org.kodein.emoji.smileys_emotion.face_concerned.*
import org.kodein.emoji.smileys_emotion.face_negative.*
import org.kodein.emoji.smileys_emotion.face_costume.*
import org.kodein.emoji.smileys_emotion.cat_face.*
import org.kodein.emoji.smileys_emotion.monkey_face.*
import org.kodein.emoji.smileys_emotion.heart.*
import org.kodein.emoji.smileys_emotion.emotion.*


internal fun EmojiFinder.addAllSmileysEmotion() {
    addAllFaceSmiling()
    addAllFaceAffection()
    addAllFaceTongue()
    addAllFaceHand()
    addAllFaceNeutralSkeptical()
    addAllFaceSleepy()
    addAllFaceUnwell()
    addAllFaceHat()
    addAllFaceGlasses()
    addAllFaceConcerned()
    addAllFaceNegative()
    addAllFaceCostume()
    addAllCatFace()
    addAllMonkeyFace()
    addAllHeart()
    addAllEmotion()
}

internal suspend fun SequenceScope<Emoji>.yieldAllSmileysEmotion() {
    yieldAllFaceSmiling()
    yieldAllFaceAffection()
    yieldAllFaceTongue()
    yieldAllFaceHand()
    yieldAllFaceNeutralSkeptical()
    yieldAllFaceSleepy()
    yieldAllFaceUnwell()
    yieldAllFaceHat()
    yieldAllFaceGlasses()
    yieldAllFaceConcerned()
    yieldAllFaceNegative()
    yieldAllFaceCostume()
    yieldAllCatFace()
    yieldAllMonkeyFace()
    yieldAllHeart()
    yieldAllEmotion()
}

internal val countSmileysEmotion = 168

/**
 * All Emoji of the Smileys & Emotion group.
*/
public fun Emoji.Companion.sequenceSmileysEmotion(): Sequence<Emoji> =
    sequence { yieldAllSmileysEmotion() }

/**
 * All Emoji of the Smileys & Emotion group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allSmileysEmotion(): List<Emoji> =
    ArrayList<Emoji>(countSmileysEmotion).also { list -> sequenceSmileysEmotion().forEach { list.add(it) } }

internal fun allSmileysEmotionSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "face_smiling" to { Emoji.listFaceSmiling() },
        "face_affection" to { Emoji.listFaceAffection() },
        "face_tongue" to { Emoji.listFaceTongue() },
        "face_hand" to { Emoji.listFaceHand() },
        "face_neutral_skeptical" to { Emoji.listFaceNeutralSkeptical() },
        "face_sleepy" to { Emoji.listFaceSleepy() },
        "face_unwell" to { Emoji.listFaceUnwell() },
        "face_hat" to { Emoji.listFaceHat() },
        "face_glasses" to { Emoji.listFaceGlasses() },
        "face_concerned" to { Emoji.listFaceConcerned() },
        "face_negative" to { Emoji.listFaceNegative() },
        "face_costume" to { Emoji.listFaceCostume() },
        "cat_face" to { Emoji.listCatFace() },
        "monkey_face" to { Emoji.listMonkeyFace() },
        "heart" to { Emoji.listHeart() },
        "emotion" to { Emoji.listEmotion() },
    )
